<?php

namespace Motors_E_W\Pro\Widgets\SingleListing;

use Motors_E_W\MotorsApp;
use STM_E_W\Helpers\Helper;
use STM_E_W\Widgets\Controls\ContentControls\HeadingControl;
use STM_E_W\Widgets\Controls\ContentControls\IconsControl;
use STM_E_W\Widgets\Controls\ContentControls\NumberControl;
use STM_E_W\Widgets\Controls\ContentControls\SwitcherControl;
use STM_E_W\Widgets\Controls\StyleControls\ColorControl;
use STM_E_W\Widgets\Controls\StyleControls\GroupTypographyControl;
use STM_E_W\Widgets\Controls\StyleControls\SliderControl;
use Motors_E_W\Pro\Widgets\WidgetBase;

class GalleryMosaic extends WidgetBase {

	use SwitcherControl, NumberControl, GroupTypographyControl, SliderControl, HeadingControl, ColorControl, IconsControl;

	public function __construct( array $data = array(), array $args = null ) {
		parent::__construct( $data, $args );

		$this->stm_ew_admin_register_ss( $this->get_admin_name(), self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION );
		$this->stm_ew_enqueue( self::get_name(), MOTORS_ELEMENTOR_WIDGETS_PATH, MOTORS_ELEMENTOR_WIDGETS_URL, MOTORS_ELEMENTOR_WIDGETS_PLUGIN_VERSION, array( 'jquery' ) );
	}

	public function get_style_depends(): array {
		$widget_styles   = parent::get_style_depends();
		$widget_styles[] = self::get_name() . '-rtl';

		return $widget_styles;
	}

	public function get_categories() {
		return array( MotorsApp::WIDGET_CATEGORY_SINGLE );
	}

	public function get_name() {
		return MotorsApp::STM_PREFIX . '-single-listing-gallery-mosaic';
	}

	public function get_title() {
		return esc_html__( 'Gallery Mosaic', 'motors-elementor-widgets' );
	}

	public function get_icon() {
		return 'eicon-gallery-justified';
	}

	protected function register_controls() {

		$this->stm_start_content_controls_section( 'Media', esc_html__( 'Media', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_switcher(
			'include_video',
			array(
				'label'   => esc_html__( 'Include videos', 'motors-elementor-widgets' ),
				'default' => 'yes',
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_content_controls_section( 'Labels', esc_html__( 'Labels', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_switcher(
			'show_sold_label',
			array(
				'label'   => esc_html__( 'Show Sold label', 'motors-elementor-widgets' ),
				'default' => 'yes',
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_content_controls_section( 'Action buttons', esc_html__( 'Actions', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_switcher(
			'show_print',
			array(
				'label'   => esc_html__( 'Print', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_compare',
			array(
				'label'   => esc_html__( 'Compare', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_share',
			array(
				'label'   => esc_html__( 'Share', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		if ( apply_filters( 'is_listing', array() ) ) {
			$this->stm_ew_add_switcher(
				'show_featured',
				array(
					'label'   => esc_html__( 'Favorite', 'motors-elementor-widgets' ),
					'default' => '',
				)
			);
		}

		$this->stm_ew_add_switcher(
			'show_test_drive',
			array(
				'label'   => esc_html__( 'Test Drive', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_ew_add_switcher(
			'show_pdf',
			array(
				'label'   => esc_html__( 'PDF', 'motors-elementor-widgets' ),
				'default' => '',
			)
		);

		$this->stm_end_control_section();

		$this->stm_start_style_controls_section( 'style', esc_html__( 'Style', 'motors-elementor-widgets' ) );

		$this->stm_ew_add_heading(
			'featured_heading',
			array(
				'label' => esc_html__( 'Featured listing label', 'motors-elementor-widgets' ),
			),
		);

		$this->stm_ew_add_group_typography(
			'featured_label_typography',
			array(
				'label'          => esc_html__( 'Label typography', 'motors-elementor-widgets' ),
				'exclude'        => array(
					'line_height',
					'text_transform',
					'text_decoration',
					'word_spacing',
				),
				'fields_options' => array(
					'font_size' => array(
						'size_units' => array(
							'px',
							'em',
						),
						'default'    => array(
							'unit' => 'px',
							'size' => 12,
						),
					),
				),
				'selector'       => '{{WRAPPER}} .stm-gallery-listing-info .special-label-inline',
			),
		);

		$this->stm_ew_add_icons(
			'featured_icon',
			array(
				'label'            => esc_html__( 'Icon', 'motors-elementor-widgets' ),
				'skin'             => 'inline',
				'fa4compatibility' => 'icon',
				'default'          => array(
					'value'   => 'fas fa-crown',
					'library' => 'fa-solid',
				),
			)
		);

		$this->stm_ew_add_slider(
			'featured_icon_size',
			array(
				'label'      => __( 'Icon Size', 'motors-elementor-widgets' ),
				'size_units' => array(
					'px',
				),
				'range'      => array(
					'px' => array(
						'min'  => 5,
						'max'  => 30,
						'step' => 1,
					),
				),
				'default'    => array(
					'size' => 12,
					'unit' => 'px',
				),
				'selectors'  => array(
					'{{WRAPPER}} .stm-gallery-listing-info .special-label-inline i'   => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .stm-gallery-listing-info .special-label-inline svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->stm_ew_add_color(
			'featured_color',
			array(
				'label'     => __( 'Color', 'motors-elementor-widgets' ),
				'selectors' => array(
					'{{WRAPPER}} .stm-gallery-listing-info .special-label-inline' => 'color: {{VALUE}};',
				),
			),
		);

		$this->stm_end_control_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		Helper::stm_ew_load_template( 'pro/widgets/single-listing/gallery-mosaic', MOTORS_ELEMENTOR_WIDGETS_PATH, $settings );
	}

	protected function content_template() {
	}
}
